package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.data.model.AccessControl;
import gov.va.med.mhv.usermgmt.data.model.AccessRoleAccessControl;
import gov.va.med.mhv.usermgmt.data.repository.AccessRoleAccessControlRepository;
import gov.va.med.mhv.usermgmt.service.AccessControlService;
import gov.va.med.mhv.usermgmt.util.AccessControlUtils;
import gov.va.med.mhv.usermgmt.util.Precondition;

/**
 * Service implementation class for the AccessControl service
 * 
 * @see gov.va.med.mhv.usermgmt.service.AccessControlService
 */
@Component
public class AccessControlServiceImpl implements AccessControlService {

	private static Logger log = LogManager.getLogger(AccessControlServiceImpl.class);

	@Autowired
	private AccessRoleAccessControlRepository accessRoleAccessControlRepository;

	/*
	 * Execute the FindAccessControls service
	 * 
	 * @see gov.va.med.mhv.usermgmt.service.AccessControlService#findAccessControls()
	 */
	public void findAccessControls(String userName, ResponseUtil<List<AccessControl>> response) {
		Precondition.assertNotBlank("userName", userName);

		List<AccessRoleAccessControl> userBasedControls = null;
		try {
			userBasedControls = accessRoleAccessControlRepository.findAccessRoleAccessControlByUserName(StringUtils.lowerCase(userName));
		} catch (Exception e) {
			log.error("Error in findAccessRoleAccessControlByUserName ", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}

		List<AccessControl> list = new ArrayList<AccessControl>();
		
		for (AccessRoleAccessControl userBasedControl : userBasedControls) {
			list.add(toAccessControl(userBasedControl));
		}
		
		response.setPojoObject(list);

		if (log.isDebugEnabled()) {
			log.debug("Found " + list.size() + "accessControls for '" + userName + "'");
		}
	}

	private AccessControl toAccessControl(AccessRoleAccessControl roleBasedControl) {
		assert roleBasedControl != null;
		AccessControl accessControl = new AccessControl();
		accessControl.setFeature(roleBasedControl.getAccessFeature());
		accessControl.setPermissions(roleBasedControl.getPermissions());
		accessControl.setRoleId(roleBasedControl.getAccessRoleId());
		accessControl.setUserProfileId(null);
		accessControl.setAccessRole(roleBasedControl.getAccessRole());
		if (log.isDebugEnabled()) {
			log.debug("Add " + AccessControlUtils.describe(accessControl));
		}
		return accessControl;
	}

}



/*
@SuppressWarnings("unchecked")
public AccessFeatureCollectionServiceResponse getAllAccessFeatures() {

	AccessFeatureCollectionServiceResponse response = new AccessFeatureCollectionServiceResponse();
	List<AccessFeatureBO> bos = AccessFeatureBO.findAllAccessFeatures();
	if (bos != null) {
		for (AccessFeatureBO bo : bos) {
			response.addAccessFeature(bo.getAccessFeatureValues());
		}
	}
	return response;
}

@SuppressWarnings("unchecked")
public AccessFeatureServiceResponse findAccessFeature(String featureName) {

	AccessFeatureServiceResponse response = new AccessFeatureServiceResponse();
	List<AccessFeatureBO> bos = AccessFeatureBO.findAccessFeature(featureName);
	if (bos != null) {
		Iterator<AccessFeatureBO> i = bos.iterator();
		if ((i != null) && i.hasNext()) {
			response.setAccessFeature(i.next().getAccessFeatureValues());
		}
	}
	return response;

}*/



//if (null != userBasedControls && userBasedControls.size() > 0) {
//if(log.isDebugEnabled()) { log.debug("Size of userBasedControls: " + userBasedControls.size()); }
//for (AccessRoleAccessControl userBasedControl : userBasedControls) {
//	String key = createKey(userBasedControl.getAccessFeature());
//	accessControls.put(key, toAccessControl(userBasedControl));
//}
//} else {
//if(log.isDebugEnabled()) { log.debug(" *** userBasedControls list is null ***"); }
//}
//
//// append AccessRole-based AccessControl
//List<AccessRoleAccessControl> roleBasedControls = null;
//try {
//roleBasedControls = accessRoleAccessControlRepository.findNationalAccessRoleAccessControl();
//} catch (RuntimeException re) {
//re.printStackTrace();
//} catch (Exception e) {
//log.error("Error resulted from findNationalAccessRoleAccessControl ", e);
//response.setFailure(true);
//response.setFailureMessage(e.getMessage());
//} catch( Throwable t ) {
//t.printStackTrace();
//}

//if (null != roleBasedControls && roleBasedControls.size() > 0) {
//for (AccessRoleAccessControl roleBasedControl : roleBasedControls) {
//	String key = createKey(roleBasedControl.getAccessFeature());
//	if (accessControls.get(key) != null) {
//		if(log.isDebugEnabled() ) {
//			log.debug("Overriding '" + roleBasedControl.getAccessRole().getName() +
//					"' UserProfile-based control, because found a Role-Based control for feature " + key + " (National)");
//		}
//	}
//	accessControls.put(key, toAccessControl(roleBasedControl));
//}
//} else {
//if(log.isDebugEnabled()) {
//	log.debug("*** roleBasedControls list is null ***");	
//}
//}

